CREATE OR REPLACE FUNCTION ADDCOLUMN()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1 
                FROM information_schema.columns     
                WHERE table_name = 'pdv_campanha_adicionais' 
                  and column_name='qtde_prod_promocionais'
	) THEN
           RAISE NOTICE 'Coluna qtde_prod_promocionais na tabela pdv_campanha_adicionais ja existe!' ;
    ELSE
		ALTER TABLE public.pdv_campanha_adicionais ADD qtde_prod_promocionais int not null default 0;
        RAISE NOTICE 'Coluna "qtde_prod_promocionais" criada com sucesso!';
    END IF; 
    
END; 


$BODY$
LANGUAGE PLPGSQL VOLATILE  COST 100;
ALTER FUNCTION ADDCOLUMN()  OWNER TO POSTGRES;
SELECT ADDCOLUMN();
DROP FUNCTION ADDCOLUMN();
